/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.core.entity;

import common.com.cursee.more_bows_and_arrows.core.entity.TieredArrowEntity;
import common.com.cursee.more_bows_and_arrows.core.item.TieredBowItem;
import common.com.cursee.more_bows_and_arrows.core.tier.BowTier;
import common.com.cursee.more_bows_and_arrows.core.util.CommonEffectsUtil;
import common.com.cursee.more_bows_and_arrows.core.util.DragonBreathUtil;
import common.com.cursee.more_bows_and_arrows.core.util.FireworkUtil;
import common.com.cursee.more_bows_and_arrows.core.util.PaperEffectsUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class ArrowHitsEntityInteractions {
    public static void interact(TieredArrowEntity tieredArrowEntity, @Nullable Entity nullableOwner, EntityHitResult entityHitResult) {
        Entity entity;
        Player player;
        block37: {
            block36: {
                if (!(nullableOwner instanceof Player)) break block36;
                player = (Player)nullableOwner;
                entity = entityHitResult.getEntity();
                if (entity instanceof LivingEntity) break block37;
            }
            return;
        }
        LivingEntity hitEntity = (LivingEntity)entity;
        switch (tieredArrowEntity.getVariant()) {
            case AMETHYST: 
            case BAMBOO: 
            case COAL: 
            case DIAMOND: 
            case EMERALD: {
                break;
            }
            case BLAZE_ROD: {
                hitEntity.setRemainingFireTicks(40);
                break;
            }
            case BONE: {
                hitEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 40, 1));
                break;
            }
            case CACTUS: {
                hitEntity.hurt(player.level().damageSources().cactus(), 1.5f);
                break;
            }
            case COPPER: {
                Item item = player.getMainHandItem().getItem();
                if (!(item instanceof TieredBowItem)) {
                    return;
                }
                TieredBowItem tieredBowItem = (TieredBowItem)item;
                if (tieredBowItem.tier != BowTier.COPPER) break;
                CommonEffectsUtil.lightingCausedByPlayer(player, hitEntity.blockPosition());
                break;
            }
            case DRAGON_BREATH: {
                DragonBreathUtil.createAreaEffectCloud(player, hitEntity.blockPosition());
                break;
            }
            case DRIPSTONE: {
                hitEntity.hurt(player.level().damageSources().playerAttack(player), 1.5f);
                break;
            }
            case ECHO: {
                Level level = player.level();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.playSound(player, hitEntity.blockPosition(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case EGG: {
                Chicken chicken = (Chicken)EntityType.CHICKEN.create(player.level());
                if (chicken == null) break;
                chicken.moveTo((double)hitEntity.blockPosition().getX(), (double)hitEntity.blockPosition().getY(), (double)hitEntity.blockPosition().getZ());
                player.level().addFreshEntity((Entity)chicken);
                break;
            }
            case ENDER_PEARL: {
                hitEntity.teleportTo(player.xo, player.yo, player.zo);
                break;
            }
            case FIREWORK: {
                FireworkUtil.createRandomFireworkFromEntity((LivingEntity)player, entityHitResult.getEntity().blockPosition());
                break;
            }
            case FIRE_CHARGE: {
                hitEntity.setRemainingFireTicks(40);
                break;
            }
            case FLINT: {
                Item item = player.getMainHandItem().getItem();
                if (!(item instanceof TieredBowItem)) break;
                TieredBowItem bow = (TieredBowItem)item;
                if (bow.tier != BowTier.IRON) break;
                hitEntity.setRemainingFireTicks(40);
                break;
            }
            case FLINT_AND_STEEL: {
                hitEntity.setRemainingFireTicks(40);
                break;
            }
            case GLOW_INK_SAC: {
                hitEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 80, 1));
                break;
            }
            case ICE: {
                hitEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 1));
                break;
            }
            case INK_SAC: {
                hitEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 80, 1));
                break;
            }
            case LADDER: {
                player.teleportTo(player.xo, (double)hitEntity.blockPosition().getY(), player.zo);
                break;
            }
            case LIGHTNING_ROD: {
                Item item = player.getMainHandItem().getItem();
                if (!(item instanceof TieredBowItem)) break;
                TieredBowItem tieredBowItem = (TieredBowItem)item;
                if (tieredBowItem.tier != BowTier.LIGHTNING_ROD) break;
                tieredArrowEntity.level().explode((Entity)player, entityHitResult.getEntity().xo, entityHitResult.getEntity().yo, entityHitResult.getEntity().zo, 4.0f, Level.ExplosionInteraction.TNT);
                break;
            }
            case NETHER_STAR: {
                player.level().explode((Entity)player, (double)hitEntity.blockPosition().getX(), (double)hitEntity.blockPosition().getY(), (double)hitEntity.blockPosition().getZ(), 4.0f, Level.ExplosionInteraction.TNT);
                tieredArrowEntity.remove(Entity.RemovalReason.DISCARDED);
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomEntityEffects(player, hitEntity);
                break;
            }
            case SHEAR: {
                Sheep sheep;
                if (!(hitEntity instanceof Sheep) || !(sheep = (Sheep)hitEntity).readyForShearing()) break;
                sheep.shear(SoundSource.PLAYERS);
                sheep.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                sheep.addEffect(new MobEffectInstance(MobEffects.HEAL, 20, 2));
                break;
            }
            case SHULKER_SHELL: {
                hitEntity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 40, 1));
                break;
            }
            case SLIMEBALL: 
            case SNOWBALL: {
                hitEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 3));
                break;
            }
            case SMOKING: {
                for (int i = 0; i < 3; ++i) {
                    double modifier = player.level().random.nextBoolean() ? 1.0 : -1.0;
                    player.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)hitEntity.blockPosition().getX(), (double)hitEntity.blockPosition().getY() + 1.0, (double)hitEntity.blockPosition().getZ(), player.level().random.nextDouble() * modifier, player.level().random.nextDouble() * modifier, player.level().random.nextDouble() * modifier);
                }
                break;
            }
            case TNT: {
                player.level().explode((Entity)player, (double)hitEntity.blockPosition().getX(), (double)hitEntity.blockPosition().getY(), (double)hitEntity.blockPosition().getZ(), 2.0f, Level.ExplosionInteraction.TNT);
                tieredArrowEntity.remove(Entity.RemovalReason.DISCARDED);
                break;
            }
            case WATER_BOTTLE: {
                if (!hitEntity.isOnFire()) {
                    return;
                }
                hitEntity.setRemainingFireTicks(1);
            }
        }
    }
}

